/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.std.vueliste;

import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integertable.IntegerTableCell;
import fr.amapj.view.engine.grid.libbutton.LibButtonLine;
import fr.amapj.view.engine.grid.libbutton.LibButtonParam;
import fr.amapj.view.engine.grid.libbutton.PopupLibButton;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.step1qte.std.grid.PopupSaisieQteContrat;
import fr.amapj.view.views.saisiecontrat.step1qte.std.vueliste.PopupSaisieQteVueListeOneDate;
import fr.amapj.view.views.saisiecontrat.step1qte.std.vueliste.VueListeLineData;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.QteTableUtils;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend.CheckOnEndSaisieQte;
import java.text.SimpleDateFormat;
import java.util.List;

public class PopupSaisieQteVueListe
extends PopupLibButton<VueListeLineData> {
    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private ContratDTO contratDTO;
    private SaisieContrat.SaisieContratData data;

    public PopupSaisieQteVueListe(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.contratDTO = data.contratDTO;
        this.popupTitle = "Mon contrat " + this.contratDTO.nom;
        this.param.readOnly = data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY;
        this.param.messageSpecifique = PopupSaisieQteVueListe.s(data.messageSpecifique);
        this.param.libButtonSave = "Continuer ...";
    }

    @Override
    public void loadParam() {
        this.param.nbLig = this.contratDTO.contratLigs.size();
        this.param.nbCol = this.contratDTO.contratColumns.size();
        this.param.allowedEmpty = false;
        this.param.libPrixTotal = this.contratDTO.nature == NatureContrat.CARTE_PREPAYEE ? "Prix des livraisons \u00e0 venir" : "Prix Total";
        this.param.largeurLib1 = 110;
        this.param.largeurLib2 = 220;
        IntegerGridCell[][] cs = this.contratDTO.extractCells();
        int i = 0;
        while (i < this.param.nbLig) {
            LibButtonLine<VueListeLineData> line = this.constructLibButtonLine(this.param, i, cs);
            this.param.lines.add(line);
            ++i;
        }
        this.param.switchButtonAction = () -> this.handleSwitchButton();
        this.param.copyFirstLineAction = () -> this.handleCopyFirstLine();
    }

    private void handleCopyFirstLine() {
        int index = this.getIndexFirstLineCommandable();
        if (index == -1) {
            return;
        }
        LibButtonLine lineRef = this.param.lines.get(index);
        int i = index;
        while (i < this.param.nbLig) {
            LibButtonLine<VueListeLineData> line = this.param.lines.get(i);
            if (line.isVisible) {
                int j = 0;
                while (j < this.param.nbCol) {
                    IntegerTableCell c = ((VueListeLineData)line.data).cells[j];
                    if (!c.isStaticText) {
                        c.qte = ((VueListeLineData)lineRef.data).cells[j].qte;
                    }
                    ++j;
                }
                this.endOfModifier(line);
            }
            ++i;
        }
        this.displayMontantTotal();
    }

    private int getIndexFirstLineCommandable() {
        List lines = this.param.lines;
        int i = 0;
        while (i < lines.size()) {
            LibButtonLine line = lines.get(i);
            if (((VueListeLineData)line.data).dateCommandable == VueListeLineData.DateCommandable.OUI) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void handleSwitchButton() {
        int i = 0;
        while (i < this.param.nbLig) {
            int j = 0;
            while (j < this.param.nbCol) {
                this.contratDTO.cell[i][j].qte = ((VueListeLineData)this.param.lines.get((int)i).data).cells[j].qte;
                ++j;
            }
            ++i;
        }
        PopupSaisieQteContrat popup = new PopupSaisieQteContrat(this.data);
        this.data.insertPopup(popup);
    }

    public LibButtonLine<VueListeLineData> constructLibButtonLine(LibButtonParam<VueListeLineData> param, int ligIndex, IntegerGridCell[][] cs) {
        ContratLigDTO lig = this.contratDTO.contratLigs.get(ligIndex);
        LibButtonLine<VueListeLineData> line = new LibButtonLine<VueListeLineData>();
        line.data = new VueListeLineData();
        ((VueListeLineData)line.data).contratDTO = this.contratDTO;
        ((VueListeLineData)line.data).cells = new QteTableUtils().convertOneLineOfCells(this.contratDTO, cs, ligIndex);
        ((VueListeLineData)line.data).dateLiv = lig.date;
        ((VueListeLineData)line.data).dateCommandable = this.computeDateCommandable(this.contratDTO, ligIndex);
        line.isVisible = this.computeVisible(lig, param);
        line.lib1 = FormatUtils.getStdDate().format(lig.date);
        line.lib2 = ((VueListeLineData)line.data).computeLib2();
        line.montant = ((VueListeLineData)line.data).computeMontant();
        line.qteTotale = ((VueListeLineData)line.data).computeQteTotale();
        if (param.readOnly) {
            line.buttonLib = "D\u00e9tails";
            line.hasButton = line.qteTotale != 0;
        } else {
            line.buttonLib = "Modifier";
            line.hasButton = ((VueListeLineData)line.data).dateCommandable == VueListeLineData.DateCommandable.OUI || line.qteTotale != 0;
        }
        return line;
    }

    private VueListeLineData.DateCommandable computeDateCommandable(ContratDTO contratDTO, int ligIndex) {
        if (contratDTO.isFullExcludedLine(ligIndex)) {
            return VueListeLineData.DateCommandable.PAS_DE_LIVRAISON;
        }
        if (contratDTO.isFullNotAvailableLine(ligIndex)) {
            return VueListeLineData.DateCommandable.NO_STOCK;
        }
        return VueListeLineData.DateCommandable.OUI;
    }

    private boolean computeVisible(ContratLigDTO lig, LibButtonParam<VueListeLineData> param) {
        if (param.readOnly) {
            return true;
        }
        return lig.isModifiable;
    }

    @Override
    protected void handleButton(LibButtonLine<VueListeLineData> line) {
        new PopupSaisieQteVueListeOneDate(line, this.param.readOnly).open(() -> this.endOfModifier(line));
    }

    private void endOfModifier(LibButtonLine<VueListeLineData> line) {
        line.lib2 = ((VueListeLineData)line.data).computeLib2();
        line.montant = ((VueListeLineData)line.data).computeMontant();
        line.qteTotale = ((VueListeLineData)line.data).computeQteTotale();
        this.refreshLine(line);
        this.displayMontantTotal();
    }

    @Override
    protected void handleContinuer() {
        this.data.validate();
        this.close();
    }

    @Override
    public boolean performSauvegarder() {
        int i = 0;
        while (i < this.param.nbLig) {
            int j = 0;
            while (j < this.param.nbCol) {
                this.contratDTO.cell[i][j].qte = ((VueListeLineData)this.param.lines.get((int)i).data).cells[j].qte;
                ++j;
            }
            ++i;
        }
        if (!new CheckOnEndSaisieQte().check(this.data)) {
            return false;
        }
        this.data.validate();
        return true;
    }
}

