/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.std.vueliste;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.StringUtils;
import fr.amapj.common.mtext.MTextLabel;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.view.engine.grid.integertable.IntegerTableCell;
import java.util.Date;

public class VueListeLineData {
    public ContratDTO contratDTO;
    public DateCommandable dateCommandable;
    public Date dateLiv;
    public IntegerTableCell[] cells;

    public boolean isEmptyLine() {
        int i = 0;
        while (i < this.cells.length) {
            if (this.cells[i].qte != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public MTextLabel computeLib2() {
        if (this.isEmptyLine()) {
            switch (this.dateCommandable) {
                case OUI: {
                    return MTextLabel.html("Votre panier est vide.", "popup-lib-button-lib2-margin25px");
                }
                case NO_STOCK: {
                    return MTextLabel.html("Il n'y a plus de produits disponibles.", "popup-lib-button-lib2-margin25px");
                }
                case PAS_DE_LIVRAISON: {
                    return MTextLabel.html("Pas de livraison ce jour l\u00e0.", "popup-lib-button-lib2-margin25px");
                }
            }
            throw new AmapjRuntimeException();
        }
        StringBuilder sb = new StringBuilder();
        if (this.dateCommandable == DateCommandable.PAS_DE_LIVRAISON) {
            sb.append("<b>ATTENTION : pas de livraison normalement !!!</b> <br/>");
        }
        sb.append("<ul>");
        for (ContratColDTO contratColDTO : this.contratDTO.contratColumns) {
            int qte = this.cells[contratColDTO.j].qte;
            if (qte == 0) continue;
            sb.append("<li>" + qte + " " + this.s(contratColDTO.nomProduit) + ", " + this.s(contratColDTO.condtionnementProduit) + "</li>");
        }
        sb.append("</ul>");
        return MTextLabel.html(sb.toString());
    }

    private String s(String value) {
        return StringUtils.s(value);
    }

    public int computeMontant() {
        int mnt = 0;
        for (ContratColDTO contratColDTO : this.contratDTO.contratColumns) {
            int qte = this.cells[contratColDTO.j].qte;
            mnt += qte * contratColDTO.prix;
        }
        return mnt;
    }

    public int computeQteTotale() {
        int qteTotale = 0;
        int i = 0;
        while (i < this.cells.length) {
            qteTotale += this.cells[i].qte;
            ++i;
        }
        return qteTotale;
    }

    public static enum DateCommandable {
        OUI,
        NO_STOCK,
        PAS_DE_LIVRAISON;

    }
}

