/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step2paiement;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.SaisiePaiementModifiable;
import fr.amapj.model.models.contrat.modele.extendparam.MiseEnFormeGraphique;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.mescontrats.InfoPaiementDTO;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.currencyvector.CurrencyVectorParam;
import fr.amapj.view.engine.grid.currencyvector.PopupCurrencyVector;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.step2paiement.PropositionPaiement;
import java.util.List;

public class PopupSaisiePaiement
extends PopupCurrencyVector {
    private InfoPaiementDTO paiementDTO;
    private SaisieContrat.SaisieContratData data;

    public PopupSaisiePaiement(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.paiementDTO = data.contratDTO.paiement;
        this.popupTitle = "Vos paiements pour le contrat " + data.contratDTO.nom;
        this.setWidth(50);
    }

    @Override
    public void loadParam() {
        new PropositionPaiement(this.data).computePropositionPaiement();
        this.param.avoirInitial = this.paiementDTO.avoirInitial;
        this.param.montantCible = this.data.contratDTO.getMontantTotal();
        this.param.largeurCol = 170;
        this.param.espaceInterCol = 3;
        this.param.hasColComment = this.computeHasColComment();
        GridHeaderLine line1 = new GridHeaderLine();
        line1.height = 40;
        line1.addCell("Date");
        line1.addCell("Montant \u20ac");
        if (this.param.hasColComment) {
            line1.addCell("Etat");
        }
        this.param.headerLines.add(line1);
        List<DatePaiementDTO> datePaiements = this.paiementDTO.datePaiements;
        int nbModifiable = this.paiementDTO.getNbModifiable();
        int i = 0;
        while (i < datePaiements.size()) {
            DatePaiementDTO datePaiement = datePaiements.get(i);
            CurrencyVectorParam.CurrencyLine line = this.computeLine(datePaiement, i, nbModifiable);
            this.param.lines.add(line);
            ++i;
        }
        this.param.hasSaveButton = this.data.modeSaisie != SaisieContrat.ModeSaisie.READ_ONLY;
        this.param.libSaveButton = this.data.getLibSaveButton();
        MiseEnFormeGraphique miseEnForme = this.data.miseEnForme;
        this.param.messageSpecifique = this.data.messageSpecifique;
        this.param.messageSpecifique2 = miseEnForme.paiementStdLib1Modifier == ChoixOuiNon.NON ? this.getDefaultMessageOrdreCheque() : miseEnForme.paiementStdLib1;
        if (this.param.hasSaveButton) {
            this.param.messageSpecifique3 = miseEnForme.paiementStdLib2Modifier == ChoixOuiNon.NON ? this.getDefaultMessageIndicationRemplissage() : miseEnForme.paiementStdLib2;
        }
    }

    private boolean computeHasColComment() {
        switch (this.data.modeSaisie) {
            case STANDARD: 
            case FOR_TEST: {
                for (DatePaiementDTO datePaiement : this.paiementDTO.datePaiements) {
                    if (datePaiement.montant == 0 || datePaiement.etatPaiement == EtatPaiement.A_FOURNIR) continue;
                    return true;
                }
                return false;
            }
            case READ_ONLY: 
            case CHEQUE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                return true;
            }
        }
        throw new AmapjRuntimeException();
    }

    private String getDefaultMessageIndicationRemplissage() {
        if (this.param.isReadOnly()) {
            return "Une proposition de paiement a \u00e9t\u00e9 calcul\u00e9e et est affich\u00e9e ci dessous.<br/>Vous devez cliquer sur Sauvegarder pour accepter cette proposition et valider votre contrat<br/><br/>";
        }
        return "Une proposition de paiement a \u00e9t\u00e9 calcul\u00e9e et est affich\u00e9e ci dessous.<br/>Vous pouvez modifier cette proposition en saisissant directement les montants en face de chaque mois<br/>Le dernier mois est calcul\u00e9 automatiquement pour ajuster le contrat<br/><br/>";
    }

    private String getDefaultMessageOrdreCheque() {
        String str = "<b>Ordre des ch\u00e8ques : " + this.paiementDTO.libCheque + "</b>";
        if (this.paiementDTO.referentsRemiseCheque.size() > 0) {
            ProdUtilisateurDTO r = this.paiementDTO.referentsRemiseCheque.get(0);
            str = String.valueOf(str) + "<br/><b>Ch\u00e8ques \u00e0 remettre \u00e0 " + r.prenom + " " + r.nom + "</b>";
        }
        return str;
    }

    private String computeRightPart(DatePaiementDTO datePaiement) {
        if (datePaiement.montant == 0) {
            return "";
        }
        switch (datePaiement.etatPaiement) {
            case A_FOURNIR: {
                return "A fournir";
            }
            case AMAP: {
                return "A l'AMAP";
            }
            case PRODUCTEUR: {
                return "Chez le producteur";
            }
        }
        throw new AmapjRuntimeException();
    }

    private CurrencyVectorParam.CurrencyLine computeLine(DatePaiementDTO datePaiement, int index, int nbLineModifiable) {
        CurrencyVectorParam.CurrencyLine line = new CurrencyVectorParam.CurrencyLine();
        line.montant = datePaiement.montant;
        line.index = index;
        line.datePaiement = datePaiement.datePaiement;
        line.rightPart = this.computeRightPart(datePaiement);
        line.status = this.computeStatus(datePaiement, nbLineModifiable, this.paiementDTO.isLastLineModifiable(datePaiement));
        return line;
    }

    private CurrencyVectorParam.CurrencyLineStatus computeStatus(DatePaiementDTO datePaiement, int nbLineModifiable, boolean isLastLineModifiable) {
        if (!datePaiement.isModifiable) {
            return CurrencyVectorParam.CurrencyLineStatus.READ_ONLY;
        }
        switch (this.data.modeSaisie) {
            case STANDARD: 
            case FOR_TEST: {
                return this.computeStandard(nbLineModifiable, isLastLineModifiable);
            }
            case CHEQUE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                return CurrencyVectorParam.CurrencyLineStatus.EDITABLE;
            }
        }
        throw new AmapjRuntimeException();
    }

    private CurrencyVectorParam.CurrencyLineStatus computeStandard(int nbLineModifiable, boolean isLastLineModifiable) {
        if (this.paiementDTO.saisiePaiementModifiable == SaisiePaiementModifiable.NON_MODIFIABLE) {
            return CurrencyVectorParam.CurrencyLineStatus.READ_ONLY;
        }
        if (nbLineModifiable == 1) {
            return CurrencyVectorParam.CurrencyLineStatus.READ_ONLY;
        }
        if (isLastLineModifiable) {
            return CurrencyVectorParam.CurrencyLineStatus.ADJUST;
        }
        return CurrencyVectorParam.CurrencyLineStatus.EDITABLE;
    }

    @Override
    public void performSauvegarder() throws OnSaveException {
        for (CurrencyVectorParam.CurrencyLine line : this.param.lines) {
            if (line.montant >= 0) continue;
            throw new OnSaveException("Les paiements saisis sont incorrects. Il y a un trop pay\u00e9 de " + new CurrencyTextFieldConverter().convertToString(-line.montant) + " \u20ac");
        }
        int i = 0;
        while (i < this.param.getNbLines()) {
            CurrencyVectorParam.CurrencyLine line = this.param.lines.get(i);
            this.paiementDTO.datePaiements.get((int)i).montant = line.montant;
            ++i;
        }
        this.data.validate();
    }
}

