/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step3signature;

import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.whitestein.vaadin.widgets.wtpdfviewer.WTPdfViewer;
import fr.amapj.service.services.edgenerator.pdf.PGEngagement;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.DocEngagementDTO;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.io.ByteArrayInputStream;
import java.io.Serializable;

public class PopupSignatureAmapienDirectView
extends CorePopup {
    private SaisieContrat.SaisieContratData data;
    private CheckBox cb;
    private PGEngagement generator;
    private byte[] pdfContent;
    private boolean standardMode = this.computeMode();

    public PopupSignatureAmapienDirectView(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.popupTitle = "Signature du document d'engagement " + data.contratDTO.nom;
        ContratDTO dto = data.contratDTO;
        this.generator = new PGEngagement(PGEngagement.PGEngagementMode.CONTRAT_A_SIGNER, dto.modeleContratId, null, null, dto, data.userId);
        if (this.standardMode) {
            this.setHeight("100%");
            this.setWidth(0, 1200);
        }
    }

    private boolean computeMode() {
        return !UI.getCurrent().getPage().getWebBrowser().isSafari();
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.pdfContent = this.generator.getByteArrayContent();
        if (this.standardMode) {
            WTPdfViewer pdfViewer = new WTPdfViewer();
            StreamResource sr = new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(this.pdfContent), "doc-engagement.pdf");
            sr.setCacheTime(0L);
            pdfViewer.setResource(sr);
            int height = BaseUiTools.getHeight() - 170;
            pdfViewer.setHeight(String.valueOf(height) + "px");
            pdfViewer.setWidth("100%");
            contentLayout.addComponent((Component)pdfViewer);
        } else {
            contentLayout.addComponent((Component)LinkCreator.createLink("doc-engagement.pdf", "T\u00e9l\u00e9charger le document", this.pdfContent));
        }
        if (BaseUiTools.isCompactMode()) {
            contentLayout.addComponent((Component)new Label(""));
            this.cb = new CheckBox("J'ai lu et je signe ce document d'engagement");
            this.cb.setValue((Object)false);
            this.cb.addStyleName("signature");
            contentLayout.addComponent((Component)this.cb);
        } else {
            HorizontalLayout hl = new HorizontalLayout();
            hl.setHeight("25px");
            contentLayout.addComponent((Component)hl);
        }
    }

    @Override
    protected void createButtonBar() {
        if (BaseUiTools.isCompactMode()) {
            this.addButtonBlank();
        } else {
            this.cb = new CheckBox("J'ai lu et je signe ce document d'engagement");
            this.cb.setValue((Object)false);
            this.cb.addStyleName("signature");
            this.popupButtonBarLayout.addComponent((Component)this.cb);
            this.popupButtonBarLayout.setExpandRatio((Component)this.cb, 1.0f);
            this.popupButtonBarLayout.setComponentAlignment((Component)this.cb, Alignment.MIDDLE_CENTER);
        }
        this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.addDefaultButton("Valider", (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
    }

    protected void handleAnnuler() {
        this.close();
    }

    public void handleSauvegarder() {
        if (!((Boolean)this.cb.getValue()).booleanValue()) {
            new MessagePopup("Signature demand\u00e9e", ContentMode.HTML, CorePopup.ColorStyle.RED, "Vous devez signer ce document d'engagement en cliquant sur la case \u00e0 cocher \"J'ai lu et je signe ce document d'engagement\"").open();
            return;
        }
        DocEngagementDTO dto = new DocEngagementDTO();
        dto.pdfContent = this.pdfContent;
        dto.vars = this.generator.getUsedVars();
        this.data.contratDTO.docEngagementDTO = dto;
        this.data.validate();
        this.close();
    }
}

