/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.stock;

import fr.amapj.service.services.stockservice.saisie.SaisieStockDTO;
import fr.amapj.service.services.stockservice.saisie.SaisieStockService;
import fr.amapj.service.services.stockservice.verifstock.ProduitEnStockDTO;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integergrid.PopupIntegerGrid;
import fr.amapj.view.engine.grid.integergrid.lignecumul.TypLigneCumul;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.stock.PopupVisualiserQteStock;
import fr.amapj.view.views.stock.SaisieQteStock;
import java.util.Date;
import java.util.List;

public class PopupSaisieQteStockMultiDate
extends PopupIntegerGrid {
    private SaisieStockDTO saisieStockDTO;
    private List<ProduitEnStockDTO> prods;
    private List<Date> dates;

    public PopupSaisieQteStockMultiDate(SaisieStockDTO saisieStockDTO) {
        this.saisieStockDTO = saisieStockDTO;
        this.prods = saisieStockDTO.verifStockDTO.verifStockDateDTO.prodStocks;
        this.dates = saisieStockDTO.verifStockDTO.dates;
        this.popupTitle = "Saisie des quantit\u00e9s limites";
        this.param.readOnly = false;
        this.param.libButtonSave = "Sauvegarder";
        this.param.messageSpecifique = SaisieQteStock.computeHeader(saisieStockDTO);
    }

    @Override
    public void loadParam() {
        this.param.nbLig = this.dates.size();
        this.param.nbCol = this.prods.size();
        this.param.cell = this.extractCells();
        this.param.allowedEmpty = true;
        this.param.ligneCumulParam.ligneCumul = TypLigneCumul.NO;
        this.param.largeurCol = 110;
        PopupVisualiserQteStock.buildHeaders(this.prods, this.dates, this.param);
    }

    private IntegerGridCell[][] extractCells() {
        IntegerGridCell[][] res = new IntegerGridCell[this.dates.size()][this.prods.size()];
        int i = 0;
        while (i < this.dates.size()) {
            int j = 0;
            while (j < this.prods.size()) {
                ProduitEnStockDTO prod = this.prods.get(j);
                IntegerGridCell c = new IntegerGridCell();
                c.qte = this.prods.get((int)j).qteDispo[i];
                if (!prod.hasConsommateurCommandable[i] && c.qte == 0) {
                    c.isStaticText = true;
                    c.staticText = "XXXXXX";
                } else {
                    c.isStaticText = false;
                }
                res[i][j] = c;
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public boolean performSauvegarder() {
        int i = 0;
        while (i < this.param.nbLig) {
            int j = 0;
            while (j < this.param.nbCol) {
                int qte = this.param.cell[i][j].qte;
                this.saisieStockDTO.qteDispoStock.updateQteMaxiStockDifferentDate(this.dates.get(i), this.prods.get((int)j).idProduit, qte);
                ++j;
            }
            ++i;
        }
        new SaisieStockService().saveStockInfo(this.saisieStockDTO);
        return true;
    }

    @Override
    public int getLineHeight(boolean readOnly) {
        return readOnly ? 26 : 32;
    }

    @Override
    public int getHeaderHeight() {
        return BaseUiTools.isCompactMode() ? 270 : 365;
    }
}

