/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.stock;

import fr.amapj.service.services.stockservice.saisie.SaisieStockDTO;
import fr.amapj.service.services.stockservice.saisie.SaisieStockService;
import fr.amapj.service.services.stockservice.verifstock.ProduitEnStockDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.IntegerGridParam;
import fr.amapj.view.engine.grid.integergrid.PopupIntegerGrid;
import fr.amapj.view.engine.grid.integergrid.lignecumul.TypLigneCumul;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.stock.SaisieQteStock;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class PopupVisualiserQteStock
extends PopupIntegerGrid {
    private SaisieStockDTO saisieStockDTO;
    private List<ProduitEnStockDTO> prods;
    private List<Date> dates;

    public PopupVisualiserQteStock(SaisieStockDTO saisieStockDTO) {
        this.saisieStockDTO = saisieStockDTO;
        this.prods = saisieStockDTO.verifStockDTO.verifStockDateDTO.prodStocks;
        this.dates = saisieStockDTO.verifStockDTO.dates;
        this.popupTitle = "Visualisation des quantit\u00e9s limites";
        this.param.readOnly = true;
        this.param.libButtonSave = "OK";
        this.param.messageSpecifique = SaisieQteStock.computeHeader(saisieStockDTO);
        this.param.messageSpecifiqueBottom = "L\u00e9gende : A / B&nbsp;&nbsp;&nbsp;&nbsp;A : quantit\u00e9 command\u00e9e&nbsp;&nbsp;&nbsp;&nbsp;B : quantit\u00e9 totale disponible";
    }

    @Override
    public void loadParam() {
        this.param.nbLig = this.dates.size();
        this.param.nbCol = this.prods.size();
        this.param.cell = this.extractCells();
        this.param.allowedEmpty = true;
        this.param.ligneCumulParam.ligneCumul = TypLigneCumul.NO;
        this.param.largeurCol = 110;
        PopupVisualiserQteStock.buildHeaders(this.prods, this.dates, this.param);
    }

    public static void buildHeaders(List<ProduitEnStockDTO> prods, List<Date> dates, IntegerGridParam param) {
        GridHeaderLine line1 = new GridHeaderLine();
        line1.addCell("Produit");
        for (ProduitEnStockDTO prod : prods) {
            line1.addCell(prod.nomProduit);
        }
        GridSizeCalculator.autoSize(line1, param.largeurCol, "Arial", 16);
        GridHeaderLine line2 = new GridHeaderLine();
        line2.style = GridHeaderLine.GridHeaderLineStyle.PRIX;
        line2.addCell("prix unitaire");
        for (ProduitEnStockDTO prod : prods) {
            line2.addCell(new CurrencyTextFieldConverter().convertToString(prod.prix));
        }
        GridHeaderLine line3 = new GridHeaderLine();
        line3.addCell("Dates");
        for (ProduitEnStockDTO prod : prods) {
            line3.addCell(prod.condtionnementProduit);
        }
        GridSizeCalculator.autoSize(line3, param.largeurCol, "Arial", 16);
        param.headerLines.add(line1);
        param.headerLines.add(line2);
        param.headerLines.add(line3);
        param.leftPartLineLargeur = 110;
        param.leftPartLineStyle = "date-saisie";
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        int i = 0;
        while (i < param.nbLig) {
            Date d = dates.get(i);
            IntegerGridLine line = new IntegerGridLine();
            line.leftPart = df.format(d);
            line.isVisible = true;
            param.lines.add(line);
            ++i;
        }
    }

    private IntegerGridCell[][] extractCells() {
        DecimalFormat df = new DecimalFormat("0.##");
        IntegerGridCell[][] res = new IntegerGridCell[this.dates.size()][this.prods.size()];
        int i = 0;
        while (i < this.dates.size()) {
            int j = 0;
            while (j < this.prods.size()) {
                ProduitEnStockDTO prod = this.prods.get(j);
                IntegerGridCell c = new IntegerGridCell();
                c.qte = this.prods.get((int)j).qteDispo[i];
                c.isStaticText = true;
                c.staticText = !prod.hasConsommateurCommandable[i] && c.qte == 0 ? "XXXXXX" : String.valueOf(df.format(prod.getQteConsomme(i))) + " / " + prod.qteDispo[i];
                res[i][j] = c;
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public boolean performSauvegarder() {
        int i = 0;
        while (i < this.param.nbLig) {
            int j = 0;
            while (j < this.param.nbCol) {
                int qte = this.param.cell[i][j].qte;
                this.saisieStockDTO.qteDispoStock.updateQteMaxiStockDifferentDate(this.dates.get(i), this.prods.get((int)j).idProduit, qte);
                ++j;
            }
            ++i;
        }
        new SaisieStockService().saveStockInfo(this.saisieStockDTO);
        return true;
    }

    @Override
    public int getLineHeight(boolean readOnly) {
        return readOnly ? 26 : 32;
    }

    @Override
    public int getHeaderHeight() {
        return BaseUiTools.isCompactMode() ? 270 : 365;
    }
}

