/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.stock;

import com.vaadin.shared.ui.label.ContentMode;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.models.contrat.modele.StockIdentiqueDate;
import fr.amapj.model.models.contrat.modele.StockMultiContrat;
import fr.amapj.service.services.stockservice.StockUtilService;
import fr.amapj.service.services.stockservice.saisie.SaisieStockDTO;
import fr.amapj.service.services.stockservice.saisie.SaisieStockService;
import fr.amapj.service.services.stockservice.verifstock.VerifStockService;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.views.stock.PopupSaisieQteStockMemeDate;
import fr.amapj.view.views.stock.PopupSaisieQteStockMultiDate;
import fr.amapj.view.views.stock.PopupVisualiserQteStock;
import java.util.List;

public class SaisieQteStock {
    public MessagePopup needHelp(Long modeleContratId) {
        if (new StockUtilService().hasModeleContratGestionStock(modeleContratId)) {
            return null;
        }
        String msg = "La gestion des limites en quantit\u00e9s (stocks) n'est pas activ\u00e9 pour ce mod\u00e8le de contrat.<br/>Si vous souhaitez activer cette fonctionnalit\u00e9, il faut d'abord le d\u00e9clarer dans le producteur </br><ul><li>Aller dans TRESORIER / Producteur </li><li>Cliquer sur Modifier </li><li>A l'\u00e9tape 1, dans le champ \"Activer la gestion des limites en quantit\u00e9 pour ce producteur\" Mettre OUI</li></ul>Ensuite, il faut le d\u00e9clarer dans le mod\u00e8le de contrat :</br><ul><li>Aller dans REFERENT / Gestion des contrats vierges </li><li>Cliquer sur Modifier </li><li>Cliquer sur les limites en quantit\u00e9s </li><li>A l'\u00e9tape 1, dans le champ \"Activer la gestion des limites en quantit\u00e9 pour ce contrat\" Mettre OUI</li></ul>";
        return new MessagePopup("Info stock", ContentMode.HTML, CorePopup.ColorStyle.GREEN, msg);
    }

    public CorePopup saisieQteStock(Long modeleContratId) {
        SaisieStockDTO saisieStockDTO = new SaisieStockService().loadStockInfo(modeleContratId, false, 0);
        if (saisieStockDTO.verifStockDTO.dates.size() == 0) {
            String msg = "Il n'y a pas de stock \u00e0 saisir (0 date).";
            return new MessagePopup("Info stock", ContentMode.HTML, CorePopup.ColorStyle.GREEN, msg);
        }
        switch (saisieStockDTO.modeleContratStockIdentiqueDate) {
            case OUI: {
                return new PopupSaisieQteStockMemeDate(saisieStockDTO);
            }
            case NON: {
                return new PopupSaisieQteStockMultiDate(saisieStockDTO);
            }
        }
        throw new AmapjRuntimeException();
    }

    public CorePopup compareQteStockQteCde(Long modeleContratId) {
        SaisieStockDTO saisieStockDTO = new SaisieStockService().loadStockInfo(modeleContratId, true, -30);
        return new PopupVisualiserQteStock(saisieStockDTO);
    }

    public CorePopup displayDetailCalculQteStockQteCde(Long modeleContratId) {
        List<String> ls = new VerifStockService().showDebug(modeleContratId);
        return new MessagePopup("Info stock", CorePopup.ColorStyle.GREEN, ls);
    }

    public static String computeHeader(SaisieStockDTO saisieStockDTO) {
        String str = "";
        if (saisieStockDTO.modeleContratStockIdentiqueDate == StockIdentiqueDate.OUI) {
            str = String.valueOf(str) + "Les quantit\u00e9s disponibles sont identiques \u00e0 chaque livraison.<br/>";
        }
        if (saisieStockDTO.modeleContratStockMultiContrat == StockMultiContrat.NON) {
            str = String.valueOf(str) + "Ces quantit\u00e9s s'appliquent uniquement au contrat " + StringUtils.s(saisieStockDTO.nomModeleContrats.get(0));
        } else {
            str = String.valueOf(str) + "Ces quantit\u00e9s sont partag\u00e9es sur les contrats suivants :<ul>";
            str = String.valueOf(str) + CollectionUtils.asString(saisieStockDTO.nomModeleContrats, "", e -> "<li>" + StringUtils.s(e) + "</li>");
            str = String.valueOf(str) + "</ul>";
        }
        return str;
    }
}

