/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.synthesemulticontrat;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.periode.PeriodeManager;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.ChoixImpressionBilanLivraison;
import fr.amapj.model.models.param.paramecran.PESyntheseMultiContrat;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.services.edgenerator.excel.EGBilanActiviteAdherent;
import fr.amapj.service.services.edgenerator.excel.cheque.EGSyntheseCheque;
import fr.amapj.service.services.edgenerator.excel.livraison.EGLivraisonAmapien;
import fr.amapj.service.services.edgenerator.excel.mntlivre.EGContratMntLivre;
import fr.amapj.service.services.edgenerator.excel.mntlivre.EGProducteurMntLivre;
import fr.amapj.service.services.edgenerator.excel.nouvelarrivant.EGAllContratsVierges;
import fr.amapj.service.services.edgenerator.excel.nouvelarrivant.EGVisiteAmap;
import fr.amapj.service.services.edgenerator.excel.stats.EGStatAnnuelleProducteur;
import fr.amapj.service.services.edgenerator.excel.stats.EGStatPeriodeContratAdherent;
import fr.amapj.service.services.edgenerator.pdf.PGLivraisonAmapien;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.template.BackOfficeLongView;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public class SyntheseMultiContratView
extends BackOfficeLongView {
    private PESyntheseMultiContrat pe;

    @Override
    public String getMainStyleName() {
        return "import-donnees";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        this.pe = (PESyntheseMultiContrat)new ParametresService().loadParamEcran(MenuList.SYNTHESE_MULTI_CONTRAT);
        this.addLabelH1(this, "Synth\u00e9ses multi contrats");
        this.addPanel("Bilan par adh\u00e9rent", this.getBilanAdherent());
        this.addPanel("Bilan par p\u00e9riode de cotisation", this.getSyntheseAdhesion());
        this.addPanel("Bilans des livraisons", this.getBilanLivraisonPanel());
        this.addPanel("Synthese des ch\u00e8ques", this.getSyntheseCheque());
        this.addPanel("Bilans des montants livr\u00e9s", this.getBilanMntLivrePanel());
        this.addPanel("Bilan par ann\u00e9e civile", this.getSyntheseAnneeCivile());
        this.addPanel("Documents de pr\u00e9sentation / d\u00e9couverte", this.getLiasseVierge());
    }

    private VerticalLayout getBilanAdherent() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addGenerator(layout, new EGBilanActiviteAdherent());
        return layout;
    }

    private VerticalLayout getBilanMntLivrePanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        if (this.pe.mntLivreContratJournalierRecap == ChoixOuiNon.OUI) {
            this.addGenerator(layout, new EGContratMntLivre(TypPeriode.JOUR, this.pe.mntLivreContratJournalierNbJourAvant, this.pe.mntLivreContratJournalierNbJourApres));
        }
        if (this.pe.mntLivreContratMensuelRecap == ChoixOuiNon.OUI) {
            this.addGenerator(layout, new EGContratMntLivre(TypPeriode.MOIS, this.pe.mntLivreContratMensuelNbJourAvant, this.pe.mntLivreContratMensuelNbJourApres));
        }
        if (this.pe.mntLivreProducteurJournalierRecap == ChoixOuiNon.OUI) {
            this.addGenerator(layout, new EGProducteurMntLivre(TypPeriode.JOUR, this.pe.mntLivreProducteurJournalierNbJourAvant, this.pe.mntLivreProducteurJournalierNbJourApres));
        }
        if (this.pe.mntLivreProducteurMensuelRecap == ChoixOuiNon.OUI) {
            this.addGenerator(layout, new EGProducteurMntLivre(TypPeriode.MOIS, this.pe.mntLivreProducteurMensuelNbJourAvant, this.pe.mntLivreProducteurMensuelNbJourApres));
        }
        return layout;
    }

    private VerticalLayout getBilanLivraisonPanel() {
        LocalDateTime now;
        PeriodeManager pm;
        List<PeriodeManager.Periode> periodes;
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        if (this.pe.mensuelImpressionRecap == ChoixOuiNon.OUI && (periodes = (pm = new PeriodeManager(now = DateUtils.getLocalDateTime(), TypPeriode.MOIS, this.pe.mensuelNbJourAvant, this.pe.mensuelNbJourApres)).getAllPeriodes()).size() > 0) {
            this.addLabelBold(layout, "Les bilans mensuels de livraison");
            for (PeriodeManager.Periode p : periodes) {
                this.addOneBloc(layout, this.pe.mensuelFormat, p.typPeriode, DateUtils.asDate(p.startDate), DateUtils.asDate(p.endDate), this.pe.mensuelPdfEditionId);
            }
        }
        if (this.pe.trimestreImpressionRecap == ChoixOuiNon.OUI && (periodes = (pm = new PeriodeManager(now = DateUtils.getLocalDateTime(), TypPeriode.TRIMESTRE, this.pe.trimestreNbJourAvant, this.pe.trimestreNbJourApres)).getAllPeriodes()).size() > 0) {
            this.addLabelBold(layout, "Les bilans trimestriels de livraison");
            for (PeriodeManager.Periode p : periodes) {
                this.addOneBloc(layout, this.pe.trimestreFormat, p.typPeriode, DateUtils.asDate(p.startDate), DateUtils.asDate(p.endDate), this.pe.trimestrePdfEditionId);
            }
        }
        return layout;
    }

    private void addOneBloc(VerticalLayout layout, ChoixImpressionBilanLivraison format, TypPeriode typPeriode, Date dateDebut, Date dateFin, Long pdfEditionId) {
        switch (format) {
            case TABLEUR: {
                this.addGenerator(layout, new EGLivraisonAmapien(typPeriode, dateDebut, dateFin, null));
                break;
            }
            case PDF: {
                this.addGenerator(layout, new PGLivraisonAmapien(typPeriode, dateDebut, dateFin, null, pdfEditionId));
                break;
            }
            case TABLEUR_ET_PDF: {
                EGLivraisonAmapien eg = new EGLivraisonAmapien(typPeriode, dateDebut, dateFin, null);
                eg.setNameToDisplaySuffix(" (Format Tableur)");
                this.addGenerator(layout, eg);
                PGLivraisonAmapien pg = new PGLivraisonAmapien(typPeriode, dateDebut, dateFin, null, pdfEditionId);
                pg.setNameToDisplaySuffix(" (Format PDF)");
                this.addGenerator(layout, pg);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    private VerticalLayout getSyntheseCheque() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addGenerator(layout, new EGSyntheseCheque(EGSyntheseCheque.Mode.CHEQUE_A_REMETTRE, null));
        this.addGenerator(layout, new EGSyntheseCheque(EGSyntheseCheque.Mode.CHEQUE_AMAP, null));
        this.addGenerator(layout, new EGSyntheseCheque(EGSyntheseCheque.Mode.CHEQUE_REMIS_PRODUCTEUR, null));
        this.addGenerator(layout, new EGSyntheseCheque(EGSyntheseCheque.Mode.TOUS, null));
        return layout;
    }

    private VerticalLayout getSyntheseAdhesion() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addGenerator(layout, new EGStatPeriodeContratAdherent());
        return layout;
    }

    private VerticalLayout getSyntheseAnneeCivile() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addGenerator(layout, new EGStatAnnuelleProducteur());
        return layout;
    }

    private VerticalLayout getLiasseVierge() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addGenerator(layout, new EGAllContratsVierges(EGAllContratsVierges.EGMode.ACTIFS));
        this.addGenerator(layout, new EGAllContratsVierges(EGAllContratsVierges.EGMode.FUTUR));
        this.addGenerator(layout, new EGVisiteAmap(EGVisiteAmap.EGMode.ACTIFS));
        this.addGenerator(layout, new EGVisiteAmap(EGVisiteAmap.EGMode.FUTUR));
        return layout;
    }

    private void addPanel(String titre, VerticalLayout content) {
        Panel utilisateurPanel = new Panel(titre);
        utilisateurPanel.addStyleName("action");
        utilisateurPanel.setContent((Component)content);
        this.addComponent((Component)utilisateurPanel);
        this.addEmptyLine(this);
    }

    private void addGenerator(VerticalLayout layout, CoreGenerator coreGenerator) {
        Link l = LinkCreator.createLink(coreGenerator, false);
        layout.addComponent((Component)l);
    }

    private Label addLabel(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addLabelBold(VerticalLayout layout, String str) {
        Label tf = new Label("<b>" + str + "</b>", ContentMode.HTML);
        layout.addComponent((Component)tf);
        return tf;
    }

    private void addButton(VerticalLayout layout, String str, Button.ClickListener listener) {
        Button b = new Button(str);
        b.addStyleName("big");
        b.addClickListener(listener);
        layout.addComponent((Component)b);
    }

    private Label addLabelH1(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        tf.addStyleName("titre");
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        layout.addComponent((Component)tf);
        return tf;
    }
}

