/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.utilisateur;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.service.services.mesadhesions.AdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionsService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.EmailValidator;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.importdonnees.UtilisateurImporter;
import fr.amapj.view.views.utilisateur.CreationUtilisateurAjoutCotisation;
import java.io.Serializable;
import java.util.List;

public class CreationUtilisateurEditorPart
extends WizardFormPopup {
    private UtilisateurDTO utilisateurDTO;
    private boolean sendMail;
    private ParametresDTO parametresGen;
    private UtilisateurService.UtilisateurInfo info;

    public CreationUtilisateurEditorPart() {
        this.setWidth(80);
        this.popupTitle = "Cr\u00e9ation d'un utilisateur";
        this.utilisateurDTO = new UtilisateurDTO();
        this.setModel(this.utilisateurDTO);
        this.saveButtonTitle = "OK";
        this.parametresGen = new ParametresService().getParametres();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldSaisie(), () -> this.checkSaisie());
        this.add(() -> this.addFieldEnvoi(), () -> this.doEnvoi());
        this.add(() -> this.addFieldComplements());
    }

    private void addFieldSaisie() {
        NotNullValidator notNull = new NotNullValidator();
        EmailValidator email = new EmailValidator();
        this.setStepTitle("les informations du nouvel utilisateur");
        this.addTextField("Nom", "nom", notNull);
        this.addTextField("Prenom", "prenom", notNull);
        this.addTextField("E mail", "email", email);
        this.addTextField("T\u00e9l\u00e9phone 1", "numTel1", new IValidator[0]);
        this.addTextField("T\u00e9l\u00e9phone 2", "numTel2", new IValidator[0]);
        this.addTextField("Adresse", "libAdr1", new IValidator[0]);
        this.addTextField("Code postal", "codePostal", new IValidator[0]);
        this.addTextField("Ville", "ville", new IValidator[0]);
    }

    private String checkSaisie() {
        UtilisateurImporter importer = new UtilisateurImporter();
        List<String> check = importer.checkThisElement(this.utilisateurDTO);
        if (check == null) {
            return null;
        }
        String err = "Impossible de cr\u00e9er cet utilisateur<br/>Il n'est pas possible de cr\u00e9er cet utilisateur.Raison : <br/>";
        for (String str : check) {
            err = String.valueOf(err) + str + "<br/>";
        }
        return err;
    }

    private void addFieldEnvoi() {
        this.setStepTitle("confirmation avant envoi");
        String str = "Vous avez demand\u00e9 \u00e0 cr\u00e9er un nouvel utilisateur.<br/><br/>Nom = <b>" + this.utilisateurDTO.nom + "</b><br/>" + "Prenom= <b>" + this.utilisateurDTO.prenom + "</b><br/>" + "E mail = <b>" + this.utilisateurDTO.email + "</b><br/><br/>";
        if (!UtilisateurUtil.canSendMailTo(this.utilisateurDTO.email)) {
            this.sendMail = false;
            str = String.valueOf(str) + "Cet utilisateur n'a pas d'email , le mot de passe va \u00eatre affich\u00e9 et vous devrez le transmettre \u00e0 l'utilisateur";
        } else if (this.parametresGen.serviceMailActif && UtilisateurUtil.canSendMailTo(this.utilisateurDTO.email)) {
            this.sendMail = true;
            str = String.valueOf(str) + "Un mot de passe va \u00eatre automatiquement g\u00e9n\u00e9r\u00e9 et un e mail sera envoy\u00e9 \u00e0 l'utilisateur";
        } else {
            this.sendMail = false;
            str = String.valueOf(str) + "Votre service de mail n'est pas actif, le mot de passe va \u00eatre affich\u00e9 et vous devrez le transmettre \u00e0 l'utilisateur";
        }
        str = String.valueOf(str) + "<br/><br/>Cliquez sur Etape Suivante pour r\u00e9aliser cette op\u00e9ration, ou Annuler pour ne rien faire";
        this.addHtml(str);
    }

    private String doEnvoi() {
        this.info = new UtilisateurService().createNewUser(this.utilisateurDTO, true, this.sendMail);
        return null;
    }

    private void addFieldComplements() {
        this.form.removeAllComponents();
        this.previousButton.setEnabled(false);
        this.cancelButton.setVisible(false);
        this.setStepTitle("compl\u00e9ments sur cet utilisateur");
        this.addHtml("L'utilisateur " + this.utilisateurDTO.nom + " " + this.utilisateurDTO.prenom + "a \u00e9t\u00e9 cr\u00e9\u00e9 avec succ\u00e9s.</br>");
        if (this.sendMail) {
            this.addHtml("Le mot de passe a \u00e9t\u00e9 envoy\u00e9 par mail directement \u00e0 l'utilisateur</br>");
        } else {
            this.addHtml("Voici le mot de passe , \u00e0 transmettre \u00e0 l'utilisateur : " + this.info.password + "</br>");
        }
        this.addHtml("</br><br/>");
        if (this.parametresGen.etatGestionCotisation == EtatModule.ACTIF) {
            String str = this.findAdhesion();
            if (str != null) {
                this.addHtml("<b>Vous avez cr\u00e9\u00e9 une adh\u00e9sion pour cet utilisateur : " + str + "</b>");
            } else {
                this.addHtml("Vous pouvez maintenant compl\u00e9ter en enregistrant tout de suite l'adh\u00e9sion de cet utilisateur.</br>");
                Button b = new Button("Enregistrer l'adh\u00e9sion", (Button.ClickListener & Serializable)e -> this.handleAdhesion());
                this.form.addComponent((Component)b);
            }
        }
    }

    private void handleAdhesion() {
        new CreationUtilisateurAjoutCotisation(this.info.id).open(() -> this.addFieldComplements());
    }

    private String findAdhesion() {
        MesAdhesionDTO adhs = new MesAdhesionsService().computeAdhesionInfo(this.info.id);
        if (adhs.enCours.size() != 0) {
            AdhesionDTO adh = adhs.enCours.get(0);
            return "P\u00e9riode :" + adh.nomPeriode + " Montant : " + new CurrencyTextFieldConverter().convertToString(adh.montantAdhesion) + " \u20ac";
        }
        return null;
    }

    @Override
    protected void performSauvegarder() {
    }
}

