/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.utilisateur;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PopupRendreActifUtilisateurMasse
extends WizardFormPopup {
    private ComplexTableBuilder<UtilisateurDTO> builder;
    private List<UtilisateurDTO> toUpdate;
    private List<UtilisateurDTO> initials;
    private boolean actif;

    public PopupRendreActifUtilisateurMasse(boolean actif) {
        this.actif = actif;
        this.setWidth(60);
        this.setHeight("100%");
        this.popupTitle = actif ? "Rendre actifs les utilisateurs en masse" : "Rendre inactifs les utilisateurs en masse";
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfo());
        this.add(() -> this.addFieldSaisie(), () -> this.readToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfo() {
        String str = "Cet outil vous permet de rendre actif ou inactif les utilisateurs en masse. (inactif = archiv\u00e9)<br/>Cet outil ne tient pas compte des r\u00e8gles de gestion des archives.Dans un cas standard, il n'est pas n\u00e9cessaire d'utiliser cet outil.";
        this.addHtml(str);
    }

    private void addFieldSaisie() {
        this.initials = new UtilisateurService().getAllUtilisateurs(this.actif ? EtatUtilisateur.INACTIF : EtatUtilisateur.ACTIF);
        this.toUpdate = new ArrayList<UtilisateurDTO>();
        if (this.initials.size() == 0) {
            this.addHtml("Il n'y a pas d'utilisateurs \u00e0 modifier.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<UtilisateurDTO>(this.initials);
        this.builder.setPageLength(20);
        this.builder.addString("Nom de l'utilisateur", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom de l'utilisateur", false, 300, e -> e.prenom);
        this.builder.addCheckBox(this.actif ? "Rendre actif cet utilisateur" : "Rendre inactif cet utilisateur", "cb", true, 150, e -> false, null);
        this.addComplexTable(this.builder);
        Button b = new Button("Tout cocher", (Button.ClickListener & Serializable)e -> this.handleToutCocher());
        this.form.addComponent((Component)b);
    }

    private void handleToutCocher() {
        int i = 0;
        while (i < this.initials.size()) {
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            cb.setValue((Object)true);
            ++i;
        }
    }

    private String readToArchive() {
        this.toUpdate = this.builder.getSelectedCheckBox("cb");
        if (this.toUpdate.size() == 0) {
            return "Vous devez selectionner au moins un utilisateur pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        String str = this.actif ? "rendre actif" : "rendre inactif";
        this.addHtml("Vous allez " + str + " " + this.toUpdate.size() + " utilisateurs");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        EtatUtilisateur status = this.actif ? EtatUtilisateur.ACTIF : EtatUtilisateur.INACTIF;
        for (UtilisateurDTO p : this.toUpdate) {
            try {
                new UtilisateurService().updateEtat(status, p.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible d'archiver l'utilisateur " + p.nom + " " + p.prenom + ". Raison : " + e.getMessage());
            }
        }
    }
}

