/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.service.services.meslivraisons;


import java.util.ArrayList;
import java.util.List;

import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Producteur;

/**
 * Informations sur les contrats d'un utilisateur
 *
 */
public class ProducteurLivraisonsDTO
{
	public String producteur;
	
	public String modeleContrat; 
	
	public Long idModeleContrat;
	
	public Long idModeleContratDate;
	
	public List<QteProdDTO> produits = new ArrayList<QteProdDTO>();
	
	public int getMontantTotal()
	{
		int mnt = 0;
		for (QteProdDTO qteProdDTO : produits) 
		{
			mnt = mnt + qteProdDTO.qte * qteProdDTO.prixUnitaireProduit;
		}
		return mnt;
	}

}
