/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.view.views.common.gapviewer;

import java.util.Date;

import fr.amapj.common.GenericUtils.Ret;

/**
 * 
 * le DateProvider retourne la date concernée qui est égale ou supérieure à la date passée en entrée 
 * si il n'y a pas de date concernée, alors retourne un objet avec le message d'erreur à afficher 
 * 
 *  La date provider peut retourner la prochaine date dans le futur ou dans le passé
 *
 */

public interface DateProvider 
{
	/**
	 * Si next = true : retourne la prochaine date qui est égale ou supérieure à ref 
	 * Si next = false : retourne la date précédente qui est strictement avant ref
	 */
	public Ret<Date> provideDate(Date ref,boolean next);
}
