/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.messagingcenter.miniproxy.core;

import fr.amapj.messagingcenter.miniproxy.core.BasicHttpDeserializer;
import fr.amapj.messagingcenter.miniproxy.core.BasicHttpSerializer;
import fr.amapj.messagingcenter.miniproxy.core.MiniProxyGson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MiniProxyServer<T extends Enum<T>> {
    private static final Logger logger = LogManager.getLogger();
    private String key;
    private Class<T> enumClass;

    protected MiniProxyServer(String key, Class<T> enumClass) {
        this.key = key;
        this.enumClass = enumClass;
    }

    protected abstract Object processServer(T var1, Object var2);

    protected abstract Class<?> findRequestClass(T var1);

    public void processRequest(InputStream is, OutputStream os) throws IOException {
        logger.info("Debut processRequest");
        BasicHttpSerializer bos = new BasicHttpSerializer(os);
        BasicHttpDeserializer bis = new BasicHttpDeserializer(is);
        String k = bis.readString(200);
        if (!this.key.equals(k)) {
            logger.info("Cl\u00e9 invalide");
            throw new IOException("Cl\u00e9 invalide");
        }
        String methodName = bis.readString();
        logger.info("Traitement de la requete :" + methodName);
        T method = Enum.valueOf(this.enumClass, methodName);
        String in = bis.readGzipString();
        Class<?> requestClass = this.findRequestClass(method);
        Object request = MiniProxyGson.createGson().fromJson(in, requestClass);
        Object response = this.processServer(method, request);
        String str = MiniProxyGson.createGson().toJson(response);
        bos.writeGzipString(str);
    }
}

