/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.service.engine.objectstorage;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.engine.objectstorage.basestorage.local.LocalBaseObjectStorageService;
import fr.amapj.service.engine.objectstorage.basestorage.remote.RemoteBaseObjectStorageService;
import fr.amapj.view.engine.ui.AppConfiguration;

public class ObjectStorageServiceProvider
{
	
	static private ObjectStorageService mainInstance;
	
	
	static public ObjectStorageService find()
	{
		if (mainInstance==null)
		{
			throw new AmapjRuntimeException("Vous devez d'abord initialiser le ObjectStorageServiceProvider");
		}
		return mainInstance;
	}

	
	public static void initialize() 
	{
		mainInstance = buildMainInstance();
	}

	private static ObjectStorageService buildMainInstance() 
	{
		AppConfiguration conf = AppConfiguration.getConf();
		if (conf.getS3StorageEndPoint()!=null)
		{
			return new ObjectStorageService(new RemoteBaseObjectStorageService(conf));
		}
		else
		{
			return new ObjectStorageService(new LocalBaseObjectStorageService());
		}
	}

	public static void close()
	{
		if (mainInstance!=null)
		{
			mainInstance.close();
		}
	}
	
	
	public static String getStatistics()
	{
		return mainInstance.getStatistics();
	}
	
}
