/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.service.services.notification.hourly.producteur;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import fr.amapj.common.DateUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.engine.deamons.DeamonsContext;


public class ProducteurNotificationService 
{
	private final static Logger logger = LogManager.getLogger();
	
	
	@DbRead
	public void sendProducteurNotification(DeamonsContext deamonsContext)
	{		
		RdbLink em = RdbLink.get();
		
		// On recherche tous les producteurs qui ont un contrat dans le futur et à l'état actif 
		em.createQuery("select distinct(mcd.modeleContrat.producteur) from ModeleContratDate mcd " +
								"where mcd.dateLiv>=:d1 and mcd.modeleContrat.etat=:etat");
		em.setParameter("d1", DateUtils.getDate());
		em.setParameter("etat", EtatModeleContrat.ACTIF);
		
		//
		List<Producteur> prods = em.result().list(Producteur.class);
				
		for (Producteur producteur : prods)
		{
			logger.info("Debut de notification du producteur : "+producteur.nom);
			try
			{
				new ProducteurFeuilleLivraisonNotificationService().sendFeuilleLivraison(producteur,em,deamonsContext);
				new ProducteurInscriptionRetardataireNotificationService().sendInscriptionRetardataire(producteur,em,deamonsContext);
			}
			catch(Exception e)
			{
				// En cas d'erreur, on intercepte l'exception pour permettre la notification des autres producteurs
				deamonsContext.nbError++;
				logger.info("Erreur pour le producteur "+producteur.nom+"\n"+StackUtils.asString(e));
			}
			logger.info("Fin de notification du producteur : "+producteur.nom);
		}
	}
}
